<?php
// +----------------------------------------------------------------------
// | 月梦网络软件系统 [ DM299 ]
// +----------------------------------------------------------------------
// | 版权所有 2021~2025 月梦网络 [ http://www.dm299.com ]
// +----------------------------------------------------------------------
// | 官方网站：http://dm299.com
// +----------------------------------------------------------------------
// | 开源协议 ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | 作者: 周志华 <124861234@qq.com>
// +----------------------------------------------------------------------

namespace plugins\Hello\controller;

use \Controller\Admin As AdminController;
use \Base\Message;
use \app\common;
use \plugins\Hello\model\Hello;

/**
 * 插件后台管理控制器
 * @package http://xxxxxxxxxxx/admin.plugin.manage?name=Hello&pc=admin&pa=index
 */
class Admin  extends  AdminController 
{
    /**
     * 插件管理页
     * @author 周志华 <124861234@qq.com>
     * @return mixed
     */
    public function index()
    {
		if( !$this->is_cached("lists",'hello') ) {
			$api = Hello::tableApi();
			$this->assign('tableApi',$api['tableApi']);
			$this->assign('pages_search',$api['pages_search']);
		}
		$this->display('lists','hello');
	}

    public function lists()
    {
		$result = Hello::lists();
		foreach($result['data'] as $key=>$val) {
			$result['data'][$key] = $val;
		}
		$this->_json($result);
	}

    /**
     * 编辑增加
     * @author 周志华 <124861234@qq.com>
     * @return bool
     */
	public function add()
    {
		$id  = !empty($_REQUEST['id']) ? $this->_validator->bNumber($_REQUEST['id']) : 0;
		$forms = Hello::forms($id);
		if( $forms==false ) Message::err('异常错误：数据不存在');
		$this->assign('bodycss','style="background:#fff;"');
		$this->assign('action',url("admin/plugin/manage?name=hello&pc=admin&pa=update&id=".$id));
		$this->assign('forms',$forms );
		$this->display('form');
	}

    /**
     * 写入编辑增加
     * @author 周志华 <124861234@qq.com>
     * @return bool
     */
	public function update()
    {
		$id  = !empty($_REQUEST['id']) ? $this->_validator->bNumber($_REQUEST['id']) : 0;
		$data = $this->_validator->lists(Hello::tableInfo(),$id);
		if( $data ) {
			$result = Hello::setDb($data,$id);
			if( $result ) {
				Hello::log('hello_update', 'admin', $id,$data['name']);
				$this->_json(array("close"=>1,'msg'=>'保存成功'));
			}
			else {
				$this->_json($result);
			}
		}
		else {
			$this->_json($this->_validator->validator_error);
		}
	}

   /** 编辑字段
     * @author 周志华 <124861234@qq.com>
     * @return bool
     */
	public function edit()
    {
		$id  = !empty($_REQUEST['id']) ? $this->_validator->bNumber($_REQUEST['id']) : 0;
		$data = $this->_validator->edit(Hello::tableInfo(),$id);
		if( $data ) {
			$result = Hello::setDb($data,$id);
			if( $result===true ) {
				Hello::log('hello_update', 'admin', $id);
				$this->_json(array("reload"=>1,'msg'=>'保存成功'));
			}
			else {
				$this->_json($result);
			}
		}
		else {
			$this->_json($this->_validator->validator_error);
		}
	}


    /**
     * 删除
     * @author 周志华 <124861234@qq.com>
     * @return bool
     */
	public function del()
    {
		$id  = !empty($_REQUEST['id']) ? $this->_validator->bNumber($_REQUEST['id']) : 0;
		Hello::del($id);
		Hello::log('hello_del', 'admin', $id);
		Hello::$cache->del('admin','action');
		$this->_json(true);
	}

    /**
     * 替换的状态
     * @author 周志华 <124861234@qq.com>
     * @return bool
     */
	public function status()
    {
		$id  = !empty($_REQUEST['id']) ? $this->_validator->bNumber($_REQUEST['id']) : 0;
		$result = Hello::status(null,$id);
		Hello::log('hello_status', 'admin', $id);
		$this->_json($result);
	}


    /**
     * 启用
     * @author 周志华 <124861234@qq.com>
     * @return bool
     */
	public function enable()
    {
		$id  = !empty($_REQUEST['id']) ? $this->_validator->bNumber($_REQUEST['id']) : 0;
		$result = Hello::status(1,$id);
		Hello::log('hello_enable', 'admin', $id);
		Hello::$cache->del('admin','action');
		$this->_json($result);
	}

    /**
     * 禁用
     * @author 周志华 <124861234@qq.com>
     * @return bool
     */
	public function disable()
    {
		$id  = !empty($_REQUEST['id']) ? $this->_validator->bNumber($_REQUEST['id']) : 0;
		$result = Hello::status(0,$id);
		Hello::log('hello_disable', 'admin', $id);
		$this->_json($result);
	}

}
